;-----------------------------------------------------------------------
;  Copyright  NetworkDLS 2002, All rights reserved
;
; THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
; ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
; THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
; PARTICULAR PURPOSE.
;-----------------------------------------------------------------------

[Setup]
;-- Main Setup Information
 AppName                         = SQL-Exchange Server x64
 AppVerName                      = SQL-Exchange Server x64 1.0.6.0
 AppCopyright                    = Copyright  1995-2006 NetworkDLS
 DefaultDirName                  = {pf}\NetworkDLS\SQL-Exchange\Server x64
 DefaultGroupName                = NetworkDLS\SQL-Exchange Server x64
 UninstallDisplayIcon            = {app}\SQLEServer.Exe
 WizardImageFile                 = "Resources\WizModernImage-IS.bmp"
 WizardSmallImageFile            = "Resources\WizModernSmallImage-IS.bmp"
 PrivilegesRequired              = PowerUser
 Uninstallable                   = Yes
 AppMutex                        = SQL-Exchange Server x64
 LicenseFile                     = Resources\EULA.txt
 Compression                     = BZIP/9
 OutputBaseFilename              = "..\..\Binary\SQLEServer x64 1.0.6.0"
;UninstallLogMode                = OverWrite
 DisableStartupPrompt            = Yes
 DirExistsWarning                = No
 ArchitecturesInstallIn64BitMode = x64
 ArchitecturesAllowed            = x64

;-- Windows 2000 & XP (Support Dialog)
 AppPublisher    = NetworkDLS
 AppPublisherURL = http://www.NetworkDLS.com/
 AppUpdatesURL   = http://www.NetworkDLS.com/
 AppVersion      = 1.0.6.0

[Tasks]
 Name: CreateShortcuts;                Description: "Create start menu icons"; GroupDescription: "Shortcut Options:";
 Name: InstallService;                 Description: "Install as service";      GroupDescription: "System Service:";
 Name: InstallService\StartService;    Description: "Start the service";       GroupDescription: "System Service:";
 Name: InstallService\InstallAgent;    Description: "Install service agent";   GroupDescription: "System Service:"; Flags: UnChecked;

[Files]
 Source: "..\Binary\x64\SQLEServer.Exe";              DestDir: "{app}";     Flags: IgnoreVersion RestartReplace;
 Source: "..\Binary\x64\ServiceAgent.Exe";            DestDir: "{app}";     Flags: IgnoreVersion RestartReplace;
 Source: "Database\SQLExch_Index_Data.MDF";           DestDir: "{app}\DB";  Flags: IgnoreVersion RestartReplace;
 Source: "Database\SQLExch_Index_Log.LDF";            DestDir: "{app}\DB";  Flags: IgnoreVersion RestartReplace;

 Source: "Resources\EULA.txt";                        DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\OpenDlg.ico";                     DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\Start.ico";                       DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\Stop.ico";                        DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\OpenCon.ico";                     DestDir: "{app}";     Flags: IgnoreVersion;

 Source: "SQL\SQLExch_Create_DB.sql";                 DestDir: "{app}\SQL"; Flags: IgnoreVersion;

 Source: "..\SharedSource\EventMsg\EventMsg.dll";     DestDir: "{app}";     Flags: IgnoreVersion RestartReplace;

[Icons]
 Name: "{group}\Open Server";             Filename: "{app}\SQLEServer.Exe";   WorkingDir: "{app}"; Parameters: "/OpenMainDialog";                   IconFilename: "{app}\OpenDlg.ico";                          Tasks: CreateShortcuts AND InstallService
 Name: "{group}\Open Console";            Filename: "{app}\SQLEServer.Exe";   WorkingDir: "{app}"; Parameters: "/OpenConsole";                      IconFilename: "{app}\OpenCon.ico";                          Tasks: CreateShortcuts AND InstallService
 Name: "{group}\Start Service";           Filename: "{app}\SQLEServer.Exe";   WorkingDir: "{app}"; Parameters: "/Start";                            IconFilename: "{app}\Start.ico";                            Tasks: CreateShortcuts AND InstallService
 Name: "{group}\Stop Service";            Filename: "{app}\SQLEServer.Exe";   WorkingDir: "{app}"; Parameters: "/Stop";                             IconFilename: "{app}\Stop.ico";                             Tasks: CreateShortcuts AND InstallService
 Name: "{group}\Run StandAlone";          Filename: "{app}\SQLEServer.Exe";   WorkingDir: "{app}"; Parameters: "/NonService";                       IconFilename: "{app}\SQLEServer.exe";   IconIndex: 0;       Tasks: CreateShortcuts
 Name: "{commonstartup}\SQLESAgent x64";  Filename: "{app}\ServiceAgent.Exe"; WorkingDir: "{app}"; Parameters: """NetworkDLS_SQLExg_Server x64""";  IconFilename: "{app}\ServiceAgent.exe"; IconIndex: 0;       Tasks: CreateShortcuts AND InstallService\InstallAgent

[Dirs]
 Name: "{app}\Logs"
 Name: "{app}\Temp"
 Name: "{app}\DB"
 
[Registry]
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; Flags: UninsDeleteKey

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "CompressionMethod";  ValueType: String; ValueData: "GZIP";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "Path";               ValueType: String; ValueData: "{app}";           Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SessionLogDir";      ValueType: String; ValueData: "{app}\Logs";      Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SQLDataFiles";       ValueType: String; ValueData: "{app}\DB";        Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "DefaultDBO";         ValueType: String; ValueData: "DBO";             Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "GUIPWD";             ValueType: Binary; ValueData: "";                Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "AuthString";         ValueType: String; ValueData: "trIeSPiUhouDlUwRLe5hie2H5awRoupiaDi8zI0fo3Y7u6R703r7e6rLacrouChi";
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "AuthKey";            ValueType: String; ValueData: "6riupiekieB8uphiuspi0tr6azl2piAth6us6ieko2zoap2818UviapHlEvo5joe";

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "ImportTempDir";      ValueType: String; ValueData: "{app}\Temp";

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SQLIndexDatabase";   ValueType: String; ValueData: "SQLExch_Index";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SQLIndexDriver";     ValueType: String; ValueData: "{{SQL Server}";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SQLIndexPassword";   ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SQLIndexServer";     ValueType: String; ValueData: "(Local)";         Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SQLIndexUserID";     ValueType: String; ValueData: "sa";              Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SQLCustDriver";      ValueType: String; ValueData: "{{SQL Server}";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SQLCustPassword";    ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SQLCustServer";      ValueType: String; ValueData: "(Local)";         Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "SQLCustUserID";      ValueType: String; ValueData: "sa";              Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "ListenPort";         ValueType: Dword;  ValueData: "6796";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "MaxClients";         ValueType: Dword;  ValueData: "10";              Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "TCPLoopDelay";       ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "ShowSplashScreen";   ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "CacheLogFile";       ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "RTOFDWI";            ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "VisualAlertOnError"; ValueType: Dword;  ValueData: "0";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "VisualAlertOnWarn";  ValueType: Dword;  ValueData: "0";               Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "StartAutomatically";     ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "DropBadPackets";         ValueType: Dword;  ValueData: "0";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "HashTimeoutMS";          ValueType: Dword;  ValueData: "1000";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "KeyGenLength";           ValueType: Dword;  ValueData: "128";             Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "NextClientID";           ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "PacketMode";             ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "PingTimeoutMS";          ValueType: Dword;  ValueData: "60000";           Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "RawHashLen";             ValueType: Dword;  ValueData: "32";              Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64"; ValueName: "CompressionLevel";       ValueType: Dword;  ValueData: "6";               Flags: CreateValueIfDoesntExist;

;--Create registry keys and values for Statistics
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64\Statistics"; ValueName: "SessionConnections";        ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64\Statistics"; ValueName: "CurrentConnections";        ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64\Statistics"; ValueName: "SessionErrors";             ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64\Statistics"; ValueName: "SessionWarnings";           ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64\Statistics"; ValueName: "SessionUpTime";             ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64\Statistics"; ValueName: "SessionBytesSent";          ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x64\Statistics"; ValueName: "SessionBytesRecv";          ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;

;--Create registry keys and values for Event Logs
 Root: HKLM; Subkey: "SYSTEM\CurrentControlSet\Services\Eventlog\SQL-Exchange\SQL-Exchange (Server) x64"; Flags: UninsDeleteKey

 Root: HKLM; Subkey: "SYSTEM\CurrentControlSet\Services\Eventlog\SQL-Exchange\SQL-Exchange (Server) x64"; ValueName: "TypesSupported";        ValueType: Dword;  ValueData: "7";                   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "SYSTEM\CurrentControlSet\Services\Eventlog\SQL-Exchange\SQL-Exchange (Server) x64"; ValueName: "EventMessageFile";      ValueType: String; ValueData: "{app}\EventMsg.dll";  Flags: CreateValueIfDoesntExist;

[UninstallDelete]
 Type: FilesAndOrDirs; Name: "{app}\Logs"

[Run]
 Filename: "{app}\SQLEServer.Exe";   Parameters: "/Install";                                        Tasks: InstallService;
 Filename: "{app}\SQLEServer.Exe";   Parameters: "/Start";                                          Tasks: InstallService\StartService;
 Filename: "{app}\ServiceAgent.Exe"; Parameters: """NetworkDLS_SQLExg_Server x64"""; Flags: NoWait; Tasks: InstallService\InstallAgent

[UninstallRun]
 Filename: "{app}\SQLEServer.Exe";    Parameters: "/Stop";   RunOnceId: "StopService";   MinVersion: 0, 4.0; Tasks: InstallService;
 Filename: "{app}\SQLEServer.Exe";    Parameters: "/Delete"; RunOnceId: "DeleteService"; MinVersion: 0, 4.0; Tasks: InstallService;
 Filename: "{app}\ServiceAgent.Exe";  Parameters: "/Close";  RunOnceId: "CloseAgent";    MinVersion: 0, 4.0; Tasks: InstallService\InstallAgent

